
clear
set mem 550m
use "Eurobarometer\04357-0001-Data.dta"

**** The next section is from the Eurobarometer trendfile
/*-------------------------------------------------------------------------*
 |                                                                         
 |            STATA SUPPLEMENTAL SYNTAX FILE FOR ICPSR 04357
 |            THE MANNHEIM EUROBAROMETER TREND FILE, 1970-2002
 |
 |
 | This Stata missing value recode program is provided for optional use with
 | the Stata system version of this data file as distributed by ICPSR.
 | The program replaces user-defined numeric missing values (e.g., -9)
 | with generic system missing "."  Note that Stata allows you to specify
 | up to 27 unique missing value codes.  Only variables with user-defined
 | missing values are included in this program.
 |
 | To apply the missing value recodes, users need to first open the
 | Stata data file on their system, apply the missing value recodes if
 | desired, then save a new copy of the data file with the missing values
 | applied.  Users are strongly advised to use a different filename when
 | saving the new file.
 |
 *------------------------------------------------------------------------*/

***************************************************************************
* THE MANNHEIM EUROBAROMETER TREND FILE: 1970-2002
*
* FIRST ICPSR VERSION
* NOVEMBER 2005
*
* THIS DATA SET HAS BEEN PRODUCED BY MANNHEIMER ZENTRUM FUR EUROPAISCHE
* SOZIALFORSCHUNG (MANNHEIM, GERMANY) AND ZENTRUM FUR UMFRAGEN, METHODEN,
* UND ANALYSEN (MANNHEIM, GERMANY).
*
***************************************************************************

replace SPLIT = . if (SPLIT == 0 | SPLIT == 9)
replace ELECLIST = . if (ELECLIST == 0 | ELECLIST == 9)
replace UNIFICTN = . if (UNIFICTN == 9 | UNIFICTN == 8)
replace MEMBRSHP = . if (MEMBRSHP == 8 | MEMBRSHP == 9)
replace BENEFIT = . if (BENEFIT == 9 | BENEFIT == 8)
replace REGRET = . if (REGRET == 8 | REGRET == 9)
replace EUSPEED1 = . if (EUSPEED1 == 98 | EUSPEED1 == 99)
replace EUSPEED2 = . if (EUSPEED2 == 98 | EUSPEED2 == 99)
replace SPEEDUP = . if (SPEEDUP == 9 | SPEEDUP == 8)
replace COMM = . if (COMM == 8 | COMM == 9)
replace COMMF = . if (COMMF == 8 | COMMF == 9)
replace ECPRES = . if (ECPRES == 8 | ECPRES == 9)
replace ECPRESF = . if (ECPRESF == 8 | ECPRESF == 9)
replace EPINFO = . if (EPINFO == 8 | EPINFO == 9)
replace EPINFOF = . if (EPINFOF == 8 | EPINFOF == 9)
replace EPIMP1 = . if (EPIMP1 == 8 | EPIMP1 == 9)
replace EPIMP2 = . if (EPIMP2 == 8 | EPIMP2 == 9)
replace EPIMPF = . if (EPIMPF == 9 | EPIMPF == 8)
replace EPELFUT = . if (EPELFUT == 9 | EPELFUT == 8)
replace MEPATT = . if (MEPATT == 9 | MEPATT == 8)
replace EUROGOV = . if (EUROGOV == 9 | EUROGOV == 8)
replace SEMMEDIA = . if (SEMMEDIA == 9 | SEMMEDIA == 8)
replace SEMHOPE = . if (SEMHOPE == 9 | SEMHOPE == 8)
replace SEMGOOD = . if (SEMGOOD == 9 | SEMGOOD == 8)
replace TRUSTEP = . if (TRUSTEP == 8 | TRUSTEP == 9)
replace TRUSTEC = . if (TRUSTEC == 8 | TRUSTEC == 9)
replace TRUSTCM = . if (TRUSTCM == 8 | TRUSTCM == 9)
replace TRUSTCJ = . if (TRUSTCJ == 8 | TRUSTCJ == 9)
replace TRUSTEO = . if (TRUSTEO == 8 | TRUSTEO == 9)
replace TRUSTECB = . if (TRUSTECB == 8 | TRUSTECB == 9)
replace TRUSTECA = . if (TRUSTECA == 8 | TRUSTECA == 9)
replace TRUSTCR = . if (TRUSTCR == 8 | TRUSTCR == 9)
replace TRUSTSEC = . if (TRUSTSEC == 8 | TRUSTSEC == 9)
replace ECFINFO = . if (ECFINFO == 9 | ECFINFO == 8)
replace ECINT3 = . if (ECINT3 == 9 | ECINT3 == 8)
replace ECINT4 = . if (ECINT4 == 9 | ECINT4 == 8)
replace ECIMP = . if (ECIMP == 9 | ECIMP == 8)
replace UNDERST = . if (UNDERST == 9 | UNDERST == 8)
replace FEEL = . if (FEEL == 9 | FEEL == 8)
replace CITIZEN = . if (CITIZEN == 8 | CITIZEN == 0 | CITIZEN == 9)
replace CPCULTUR = . if (CPCULTUR == 9 | CPCULTUR == 8)
replace CPCURR = . if (CPCURR == 9 | CPCURR == 8)
replace CPDATAP = . if (CPDATAP == 9 | CPDATAP == 8)
replace CPDRUGS = . if (CPDRUGS == 9 | CPDRUGS == 8)
replace CPEDUC = . if (CPEDUC == 9 | CPEDUC == 8)
replace CPENVIR = . if (CPENVIR == 9 | CPENVIR == 8)
replace CPFORPOL = . if (CPFORPOL == 9 | CPFORPOL == 8)
replace CPIMMIGR = . if (CPIMMIGR == 9 | CPIMMIGR == 8)
replace CPINDUST = . if (CPINDUST == 9 | CPINDUST == 8)
replace CPPASYL = . if (CPPASYL == 9 | CPPASYL == 8)
replace CPPRESS = . if (CPPRESS == 9 | CPPRESS == 8)
replace CPSCIEN = . if (CPSCIEN == 9 | CPSCIEN == 8)
replace CPSECUR = . if (CPSECUR == 9 | CPSECUR == 8)
replace CPTHIRD = . if (CPTHIRD == 9 | CPTHIRD == 8)
replace CPUNEMP = . if (CPUNEMP == 9 | CPUNEMP == 8)
replace CPVATAX = . if (CPVATAX == 9 | CPVATAX == 8)
replace CPWELFAR = . if (CPWELFAR == 9 | CPWELFAR == 8)
replace CPWORKER = . if (CPWORKER == 9 | CPWORKER == 8)
replace CPWORSEC = . if (CPWORSEC == 9 | CPWORSEC == 8)
replace SATISLFE = . if (SATISLFE == 9 | SATISLFE == 8)
replace HAPPINSS = . if (HAPPINSS == 9 | HAPPINSS == 8)
replace BETTER = . if (BETTER == 9 | BETTER == 8)
replace ECONPAST = . if (ECONPAST == 9 | ECONPAST == 8)
replace FINAPAST = . if (FINAPAST == 9 | FINAPAST == 8)
replace PEACEFUL = . if (PEACEFUL == 9 | PEACEFUL == 8)
replace CONFLICT = . if (CONFLICT == 9 | CONFLICT == 8)
replace WORLDWAR = . if (WORLDWAR == 98 | WORLDWAR == 99)
replace POLDISC = . if (POLDISC == 8 | POLDISC == 9)
replace PERSUADE = . if (PERSUADE == 8 | PERSUADE == 9)
replace POLINT = . if (POLINT == 9 | POLINT == 8)
replace NEWSTV = . if (NEWSTV == 8 | NEWSTV == 9)
replace NEWSPAP = . if (NEWSPAP == 8 | NEWSPAP == 9)
replace NEWSRAD = . if (NEWSRAD == 8 | NEWSRAD == 9)
replace SOCHANGE = . if (SOCHANGE == 9 | SOCHANGE == 8)
replace VALPRI1 = . if (VALPRI1 == 8 | VALPRI1 == 9)
replace VALPRI2 = . if (VALPRI2 == 9 | VALPRI2 == 8)
replace RELIMP = . if (RELIMP == 8 | RELIMP == 9)
replace NATPRIDE = . if (NATPRIDE == 8 | NATPRIDE == 9)
replace SATISDMO = . if (SATISDMO == 9 | SATISDMO == 8)
replace SATISDEU = . if (SATISDEU == 9 | SATISDEU == 8)
replace EFFICACY = . if (EFFICACY == 9 | EFFICACY == 8)
replace MVANM = . if (MVANM == 9 | MVANM == 8)
replace MVANW = . if (MVANW == 9 | MVANW == 8)
replace MVECOL = . if (MVECOL == 9 | MVECOL == 8)
replace MVNATUR = . if (MVNATUR == 9 | MVNATUR == 8)
replace CLOSEPTY = . if (CLOSEPTY == 9 | CLOSEPTY == 8)
replace FEELCLO = . if (FEELCLO == 0 | FEELCLO == 998 | FEELCLO == 999)
replace VOTEINT = . if (VOTEINT == 0 | VOTEINT == 998 | VOTEINT == 999)
replace INCLVOTE = . if (INCLVOTE == 0 | INCLVOTE == 998 | INCLVOTE == 999)
replace LASTVOTE = . if (LASTVOTE == 0 | LASTVOTE == 998 | LASTVOTE == 999)
replace PARTICIP = . if (PARTICIP == 9 | PARTICIP == 8)
replace EUVONEXT = . if (EUVONEXT == 0 | EUVONEXT == 998 | EUVONEXT == 999)
replace LRS = . if (LRS == 98 | LRS == 99)
replace PARTY = . if (PARTY == 9 | PARTY == 8)
replace UNIONR = . if (UNIONR == 8 | UNIONR == 9)
replace UNIONHH = . if (UNIONHH == 9 | UNIONHH == 8)
replace UNIONS = . if (UNIONS == 98 | UNIONS == 99)
replace MARRIED = . if (MARRIED == 98 | MARRIED == 99)
replace EDUC = . if (EDUC == 98 | EDUC == 99)
replace EDUCREC = . if (EDUCREC == 8 | EDUCREC == 9)
replace SEX = . if (SEX == 8 | SEX == 9)
replace AGE = . if (AGE == 0)
replace AGEREC1 = . if (AGEREC1 == 98)
replace AGEREC2 = . if (AGEREC2 == 98)
replace AGEREC3 = . if (AGEREC3 == 98)
replace AGEREC4 = . if (AGEREC4 == 8 | AGEREC4 == 9)
replace SIZEHH = . if (SIZEHH == 98 | SIZEHH == 99)
replace CHILDREN = . if (CHILDREN == 98 | CHILDREN == 99)
replace CHILDOLD = . if (CHILDOLD == 98 | CHILDOLD == 99)
replace CHILDYNG = . if (CHILDYNG == 98 | CHILDYNG == 99)
replace OCCUP = . if (OCCUP == 998 | OCCUP == 999)
replace LSTOCCUP = . if (LSTOCCUP == 900)
replace LSTOCCUP = . if (LSTOCCUP >= 997 & LSTOCCUP <= 999)
replace SECOCCUP = . if (SECOCCUP == 8 | SECOCCUP == 9)
replace FIRM1 = . if (FIRM1 == 8 | FIRM1 == 9)
replace FIRM2 = . if (FIRM2 == 8 | FIRM2 == 9)
replace HH = . if (HH == 8 | HH == 9)
replace MHW = . if (MHW == 8 | MHW == 9)
replace MIE = . if (MIE == 8 | MIE == 9)
replace OCCUPHH = . if (OCCUPHH == 998 | OCCUPHH == 999)
replace LSTOCCHH = . if (LSTOCCHH == 900)
replace LSTOCCHH = . if (LSTOCCHH >= 997 & LSTOCCHH <= 999)
replace SOCLASS = . if (SOCLASS == 98 | SOCLASS == 99)
replace TYPECMTY = . if (TYPECMTY == 9 | TYPECMTY == 8)
replace DENOM = . if (DENOM == 998 | DENOM == 999)
replace CHURCHAT = . if (CHURCHAT == 8 | CHURCHAT == 9)
replace RELIGF1 = . if (RELIGF1 == 9 | RELIGF1 == 8)
replace RELIGF2 = . if (RELIGF2 == 8 | RELIGF2 == 9)
replace INCOME = . if (INCOME == 98 | INCOME == 99)
replace SIZECMTY = . if (SIZECMTY == 98 | SIZECMTY == 99)
replace REGIONAT = . if (REGIONAT == 0)
replace REGIONAT = . if (REGIONAT >= 990 & REGIONAT <= 999)
replace LANGUAGE = . if (LANGUAGE == 8 | LANGUAGE == 9)
replace MATPMAT = . if (MATPMAT == 7 | MATPMAT == 8 | MATPMAT == 9)
replace MEDIAUSE = . if (MEDIAUSE == 7 | MEDIAUSE == 8 | MEDIAUSE == 9)
replace OLI = . if (OLI == 8 | OLI == 9)
replace SCMI = . if (SCMI == 7 | SCMI == 8)
replace EPPI = . if (EPPI == 98 | EPPI == 99)
replace TEA = . if (TEA == 7 | TEA == 8 | TEA == 9)

***** My own codes start here
gen str3 cty=""
replace cty="FRA" if NATION1==1
replace cty="BEL" if NATION1==2
replace cty="NLD" if NATION1==3
replace cty="FRG" if NATION1==4   /*FRG = West Germany */
replace cty="ITA" if NATION1==5
replace cty="LUX" if NATION1==6
replace cty="DNK" if NATION1==7
replace cty="IRL" if NATION1==8
replace cty="GBR" if NATION1==9  /* Note: Great Britain separate from Northern Ireland */
replace cty="NIR" if NATION1==10  /* Be aware of Northern Ireland being coded separately; I'm going to undo that below */
replace cty="GRC" if NATION1==11
replace cty="ESP" if NATION1==12
replace cty="PRT" if NATION1==13
replace cty="GDR" if NATION1==14 /*GDR = East Germany*/
replace cty="NOR" if NATION1==15
replace cty="FIN" if NATION1==16
replace cty="SWE" if NATION1==17
replace cty="AUT" if NATION1==18

* Fold Northern Ireland back in
replace cty="GBR" if cty=="NIR"


gen str3 cty2=""
replace cty2="AUT" if NATION2==18
replace cty2="BEL" if NATION2==2
replace cty2="DNK" if NATION2==7
replace cty2="ESP" if NATION2==12
replace cty2="FIN" if NATION2==16
replace cty2="FRA" if NATION2==1
replace cty2="GBR" if NATION2==9
replace cty2="GER" if NATION2==4
replace cty2="GRC" if NATION2==11
replace cty2="IRL" if NATION2==8
replace cty2="ITA" if NATION2==5
replace cty2="LUX" if NATION2==6
replace cty2="NLD" if NATION2==3
replace cty2="NOR" if NATION2==15
replace cty2="PRT" if NATION2==13
replace cty2="SWE" if NATION2==17


gen date=.
replace date=1970.5 if EB==1
replace date=1971.5 if EB==2
replace date=1973.5 if EB==3
replace date=1974.75 if EB==20
replace date=1975.25 if EB==30
replace date=1975.75 if EB==40
replace date=1976.25 if EB==50
replace date=1976.75 if EB==60
replace date=1977.25 if EB==70
replace date=1977.75 if EB==80
replace date=1978.25 if EB==90
replace date=1978.75 if EB==100
replace date=1978.75 if EB==101
replace date=1979.25 if EB==110
replace date=1979.75 if EB==120
replace date=1980.25 if EB==130
replace date=1980.75 if EB==140
replace date=1981.25 if EB==150
replace date=1981.75 if EB==160
replace date=1982.25 if EB==170
replace date=1982.75 if EB==180
replace date=1983.25 if EB==190
replace date=1983.75 if EB==200
replace date=1984.25 if EB==210
replace date=1984.75 if EB==220
replace date=1985.25 if EB==230
replace date=1985.75 if EB==240
replace date=1986.25 if EB==250
replace date=1986.75 if EB==260
replace date=1987.25 if EB==270
replace date=1987.75 if EB==280
replace date=1988.25 if EB==290
replace date=1988.75 if EB==300
replace date=1989.25 if EB==310
replace date=1989.5 if EB==311
replace date=1989.75 if EB==320
replace date=1989.75 if EB==321
replace date=1990.25 if EB==330
replace date=1990.75 if EB==340
replace date=1990.75 if EB==341
replace date=1991.25 if EB==350
replace date=1991.25 if EB==351
replace date=1991.75 if EB==360
replace date=1992.25 if EB==370
replace date=1992.25 if EB==371
replace date=1992.75 if EB==380
replace date=1992.75 if EB==381
replace date=1993.25 if EB==390
replace date=1993.25 if EB==391
replace date=1993.75 if EB==400
replace date=1994.25 if EB==410
replace date=1994.25 if EB==411
replace date=1994.75 if EB==420
replace date=1995.25 if EB==430
replace date=1995.25 if EB==431
replace date=1995.25 if EB==432
replace date=1995.75 if EB==440
replace date=1995.75 if EB==441
replace date=1996.25 if EB==451
replace date=1996.75 if EB==460
replace date=1996.75 if EB==461
replace date=1997 if EB==470
replace date=1997.25 if EB==471
replace date=1997.25 if EB==472
replace date=1997.75 if EB==480
replace date=1998.25 if EB==490
replace date=1998.75 if EB==500
replace date=1998.75 if EB==501
replace date=1999.25 if EB==510
replace date=1999.25 if EB==511
replace date=1999.75 if EB==520
replace date=1999.75 if EB==521
replace date=2000.25 if EB==530
replace date=2000.75 if EB==540
replace date=2000.75 if EB==541
replace date=2001 if EB==542
replace date=2001.25 if EB==550
replace date=2001.25 if EB==551
replace date=2001.25 if EB==552
replace date=2001.5 if EB==560
replace date=2001.75 if EB==561
replace date=2001.75 if EB==562
replace date=2002 if EB==563
replace date=2002 if EB==570
replace date=2002.25 if EB==571
replace date=2002.25 if EB==572

gen sex=SEX if SEX==1 | SEX==2
gen year=YEAR
gen wt=WSAMPLE
replace wt=WNATION if cty=="GBR"
gen happy=HAPPINSS
gen sat=5-SATISLFE
gen hap=4-HAPPINSS

compress

saveold "Processed files\eurobarometer_micro", replace

*** Merge in the data from 2002 to Present (I have only done Life Sat)
clear
use "Eurobarometer\Eurobarometer 2002-2007.dta", clear
keep cty sat* n pop eb date
gen nwt=n
collapse (mean) sat1 sat2 sat3 sat4 pop (sum) nwt [aw=n], by(cty date eb) /* This combines the two Cyprus samples */
reshape long sat, i(cty eb date) j(satlevel)
gen n=sat*nwt
egen ctyebsat=group(cty eb sat)
expandcl n, generate(id) cluster(ctyebsat)
drop sat nwt n ctyebsat id
gen macro=1
la var macro "Data are not from trendfile; hand-entered"
drop if date==2002.25 /*This is in the trendfile*/
rename satlevel sat
gen wt=1
egen sumwt=sum(wt), by(cty eb)
gen wt_euro=pop/sumwt
levelsof eb, local(ebs)
for X in any NOR HRV MKD TUR: replace wt_euro=. if cty=="X"
for X in any BGR CYP CZE EST HUN LIT LVA MLT POL ROM SVK SVN \ Y in any 2007 2004.33 2004.33 2004.33 2004.33 2004.33 2004.33 2004.33 2004.33 2007 2004.33 2004.33: replace wt_euro=. if cty=="X" & date<Y
foreach e of local ebs {
	summ wt_euro if eb==`e'
	replace wt_euro=wt_euro/r(mean) if eb==`e'
}
gen year=int(date)
append using "Processed files\eurobarometer_micro"
replace eb=EB if eb==.
replace wt_euro=WEURO if macro~=1

sort cty year
merge cty year using "Processed files\Complete_GDP"
drop if _merge==2
rename _merge _merge_gdp
drop _merge*
saveold "Processed files\eurobarometer_micro", replace

*** Create a macro dataset
use "Processed files\eurobarometer_micro" if sat~=. | hap~=., clear
keep cty sat hap date wt wt_euro gdp pop eb
gen nhap=1 if hap~=.
gen nsat=1 if sat~=.
collapse (sum) wt wt_euro nhap nsat (mean) gdp eb, by(sat hap cty date)
egen ctydt=group(cty date)
xi: oprobit sat i.ctydt [aw=wt]
predict sat_hat if sat~=., xb
summ sat_hat [aw=wt]
replace sat_hat=sat_hat-r(mean)
xi: oprobit hap i.ctydt [aw=wt]
predict hap_hat if hap~=., xb
summ hap_hat [aw=wt]
replace hap_hat=hap_hat-r(mean)

gen vs=(sat==4) if sat~=. & wt~=.
xi: reg vs i.ctydt [aw=wt]
predict vsat if vs~=.
gen vh=(hap==3) if hap~=. & wt~=.
xi: reg vh i.ctydt [aw=wt]
predict vhap if vh~=.

collapse (mean) gdp vsat vhap sat_hat hap_hat (sum) nsat nhap wt wt_euro, by(cty eb date)
collapse (mean) gdp vsat vhap sat_hat hap_hat eb wt_euro (sum) nsat nhap wt, by(cty date)

gen lgdp=ln(gdp)
gen year=int(date)
egen ctyid=group(cty)
gen y=year+.5
gen lgdp_q=.
levelsof cty, local(countries)
foreach c of local countries {
	summ gdp if cty=="`c'" & year==2006
	replace gdp=r(mean)*1.015 if cty=="`c'" & year==2007
	replace lgdp=log(gdp) if lgdp==.
	ipolate lgdp date if cty=="`c'", gen(i)
	replace lgdp_q=i if lgdp_q==.
	drop i
}
gen gdp_q=exp(lgdp_q)
la var gdp_q "GDP, quarterly interpolation"
rename gdp gdp_a 
la var gdp_a "GDP, annual"
rename lgdp lgdp_a
compress
sort cty date
saveold "Processed files\eurobarometer_macro", replace

*** Make sure that these interpolated data are included on the micro data
use "Processed files\eurobarometer_micro", clear
sort cty date
merge cty date using "Processed files\eurobarometer_macro", keep(gdp_a lgdp_a gdp_q lgdp_q sat_hat hap_hat)
drop if _merge==1
saveold "Processed files\eurobarometer_micro", replace

